/*
 * Project: Mellon-2 FirmWare C.X
 * File: main.c
 * Revision:4.10
 * Author: LaV
 
 *Задействованы прерывания для 2-го считывателя. RB3 использует прерывания ССР2-модуля 
 * Created on 14 Июня 2018 г., 1:51
 */
#include <xc.h>
#include <p18f452.h>
#include <stdint.h>
#include "delays.h"
#include "eeprom.h"
#include "init.h"
#include "I2C.h"
#include "utilits.h"
#include "rs485.h"

#pragma config OSC = HS, WDT = OFF, LVP = OFF, CCP2MUX = OFF
#define _XTAL_FREQ 16000000

void delay10Hz(void){
Delay10KTCYx(23.04);//9216000/(10000*4*23.04)= 10Hz.
}
void delay5kHz(void){
Delay10KTCYx(1);//8000000/(10000*4*1)= 5kHz.
}
//const char mem [26] @ 0x20 = {0,1,0,1,1,0,1,0,1,0,0,1,0,0,1,0,1,1,0,0,1,0,1,1,0,1};
//char fcode_mem  = 181;
//int idcode_mem = 9622;
//char id_l_mem = 37;
//char id_h_mem = 150;
void main(void) {
    init();     
    hello();
    RC0 = 1;//HL5
    //Тест I2C EEPROM
    //unsigned char h_addr = 0xA5;
    //unsigned char l_addr = 0x00;
    //unsigned char data = 0xE6; 
    //unsigned char data1 = 0xE7;
    //unsigned char data2 = 0xE8;    
    //I2C_Write_3byte(h_addr, l_addr, data, data1, data2);//записать 1 байт 
    //I2C_AckPoll();I2C_AckWait()
    //I2C_Delete_all();
    //I2C_AckPoll();//проверка готовности микросхемы
    //I2C_AckWait();//если занята, - ждем
    //I2C_Read_3byte(h_addr, l_addr);  
    //I2C_AckPoll(); I2C_AckWait();
    h_addr = I2C_Read(0xFF,0xFE); //читаем последний занятый (старший)адресс
    I2C_AckPoll(); I2C_AckWait();
    l_addr = I2C_Read(0xFF,0xFD);//читаем последний занятый (младший)адресс
    if(h_addr == 0xFF && l_addr == 0xFF) h_addr = 0, l_addr = 0;
    
 while(1){         
        if(RA1 == 0 || data_rx == 0x31)access1_on(), data_rx = 0;//нажата кнопка выход1
        if(RE0 == 0 || data_rx == 0x32)access2_on(), data_rx = 0;//нажата кнопка выход2          
        if (i == 26){//обработка считывателя 1
            i = 0;   
            fcode = bin2dec(8,0,dat);//конвертим facility (эелементы 8-1)
            id_l = bin2dec(24,16,dat);//конвертим младший байт idcard (24-17)
            id_h = bin2dec(16,8,dat);//конвертим старший байт idcard (16-9) 
            I2C_card_search_p();// постраничный поиск карты в I2C eeprom
            rs485_TxByte(fcode);
            rs485_TxByte(id_h);      
            rs485_TxByte(id_l);      
            if(RD7 == 0 && card_found == 0){//тампер нажат и карта не найдена, то добавить в eeprom                
                I2C_AckPoll(); I2C_AckWait();
                I2C_Write_3byte(h_addr, l_addr, fcode, id_h, id_l);
                l_addr = l_addr+3;
                if(l_addr == 255)l_addr = 0, h_addr++;
                I2C_AckPoll(); I2C_AckWait();
                I2C_Write_3byte(0xFF, 0xFD, l_addr, h_addr, 0x00);//записываем последний занятый адрес
            }            
            if(card_found == 1)access1_on();
            if(card_found == 0)access1_off();  
            time = 0;
            while(time <= 1);//Защитная пауза от сбоя счетчика i(ждем окончания передачи считывателя)
            //delay10Hz();//Защитная пауза от сбоя счетчика i(ждем окончания передачи считывателя)
            card_found = 0;
            fcode = 0;
            id_l = 0;
            id_h = 0;
            i = 0; 
        }
        if(i2 == 26){//обработка считывателя 2
            i2 = 0; i=0; 
            fcode = bin2dec(8,0,dat2);//конвертим facility (эелементы 8-1)
            id_l = bin2dec(24,16,dat2);//конвертим младший байт idcard (24-17)
            id_h = bin2dec(16,8,dat2);//конвертим старший байт idcard (16-9)             
            I2C_card_search_p();//постраничный поиск карты в I2C eeprom
            rs485_TxByte(fcode);
            rs485_TxByte(id_h);      
            rs485_TxByte(id_l); 
            if(RD7 == 0 && card_found == 0){//тампер нажат и карта не найдена
                I2C_AckPoll(); I2C_AckWait();
                I2C_Write_3byte(h_addr, l_addr, fcode, id_h, id_l);
                l_addr = l_addr+3;
                if(l_addr == 255)l_addr = 0, h_addr++;
                I2C_AckPoll(); I2C_AckWait();
                I2C_Write_3byte(0xFF, 0xFD, l_addr, h_addr, 0x00);//записываем последний занятый адрес               
            }            
            if(card_found == 1)access2_on();
            if(card_found == 0)access2_off();
            time = 0;
            while(time <= 1);//Защитная пауза от сбоя счетчика i2(ждем окончания передачи считывателя)
            //delay10Hz();//Защитная пауза от сбоя счетчика i2(ждем окончания передачи считывателя)
            card_found = 0;
            fcode = 0;
            id_l = 0;
            id_h = 0; 
            i2 = 0;  
        }
    }     
 return;
}
void interrupt high_priority h_ir (void){
//reader1(INT0,INT1)------------------------------------------------------------ 
//RB0-INTO,RB1-INT1    
    if (INT0IF == 1){
        INT0IF = 0;
        dat[i] = 0;
        i++; 
    }
    if(INT1IF == 1){
        INT1IF = 0;        
        dat[i] = 1;
        i++; 
    }       
//reader2(INT2,CCP2)------------------------------------------------------------
//RB2-INT2,RB3-CCP2  
    if(INT2IF == 1){
        INT2IF = 0;       
        dat2[i2] = 0;
        i2++;
    }
    if(CCP2IF == 1){
       CCP2IF = 0;       
       dat2[i2] = 1;
       i2++;
    } 
//RS485-------------------------------------------------------------------------
if(RCIF == 1){data_rx = RCREG;}//Буфер приемника полон    
}
void interrupt low_priority l_ir (void){    
    /*if(TMR1IF == 1){////время таймера:1/(9216000/4/8/(65535-36735)) = 0,1с.
      if(TMR1IF == 1 && RC0 == 0) TMR1 = 36735, TMR1IF = 0, RC0 = 1;//частота моргания диода: 1/(0,1с+0,1с)=5Гц 36735
      if(TMR1IF == 1 && RC0 == 1) TMR1 = 36735, TMR1IF = 0, RC0 = 0;//отсчет от 36735 до 65535          
    }*/
    if(TMR1IF == 1)time_exit1++, time_exit2++, time++; TMR1IF = 0, TMR1 = 36735;
    if(time_exit1 > 50)access1_off(),time_exit1 = 0;//автоматическиое закрытие двери через 3с
    if(time_exit2 > 50)access2_off(),time_exit2 = 0; 
}


